#!/bin/bash

# Train
ID="ICLR-RLM-CL-DRL3"
MODE='train'
CHECKPOINT="results/models/Pretrain-PHYDRL5"
TEACHER_ENABLE=true
TEACHER_LEARN=true
WITH_FRICTION=true
FRICTION_CART=30
ACTUATOR_NOISE=true
DRL_MAGNITUDE=50

APPLY_UNKNOWN_DISTRIBUTION=true
RANDOM_RESET_SEED=2
#TRAIN_RANDOM_RESET=true
#EVAL_RANDOM_RESET=true
TRAIN_RANDOM_RESET=false
EVAL_RANDOM_RESET=false

#TRAINING_BY_STEPS=true
#MAX_TRAINING_STEPS=2e5
TRAINING_BY_STEPS=false
MAX_TRAINING_EPISODES=5
GAMMA=0


python main.py \
  general.id=${ID} \
  general.mode=${MODE} \
  general.checkpoint=${CHECKPOINT} \
  general.training_by_steps=${TRAINING_BY_STEPS} \
  general.max_training_episodes=${MAX_TRAINING_EPISODES} \
  cartpole.with_friction=${WITH_FRICTION} \
  cartpole.friction_cart=${FRICTION_CART} \
  cartpole.random_reset.seed=${RANDOM_RESET_SEED} \
  cartpole.random_reset.train=${TRAIN_RANDOM_RESET} \
  cartpole.random_reset.eval=${EVAL_RANDOM_RESET} \
  ha_teacher.teacher_enable=${TEACHER_ENABLE} \
  ha_teacher.teacher_learn=${TEACHER_LEARN} \
  hp_student.phydrl.gamma=${GAMMA} \
  hp_student.agents.unknown_distribution.apply=${APPLY_UNKNOWN_DISTRIBUTION} \
  hp_student.agents.action.magnitude=${DRL_MAGNITUDE}

